#include "cLearn.h"

VOID Parse(MAP<STRING, STRING> params, INT32 &value, STRING name) { if (params.find(name) != params.end()) value = atoi(params[name].c_str()); }
VOID Parse(MAP<STRING, STRING> params, FLOAT &value, STRING name) { if (params.find(name) != params.end()) value = atof(params[name].c_str()); }
VOID Parse(MAP<STRING, STRING> params, STRING &value, STRING name) { if (params.find(name) != params.end()) value = params[name]; }

ASLParameter::ASLParameter(MAP<STRING, STRING> params)
{
	Parse(params, SourceRepositoryPath, "src");
	Parse(params, TargetRepositoryPath, "trg");
	Parse(params, BlockFile, "block");
	Parse(params, AlignmentFile, "align");
	Parse(params, SplitFile, "split");
	Parse(params, LabelFile, "label");	
	Parse(params, Jobname, "name");
	Parse(params, TopSimFunctionCount, "topsim");
	Parse(params, ThreadCount, "thread");
	Parse(params, FilteringFactor, "filtering");
	Parse(params, BlockBuffer, "buffer");
	Parse(params, MinSplitCount, "minsplit");
	Parse(params, MaxSplitCount, "maxsplit");
	Parse(params, TrainingSplit, "training");
	Parse(params, TestSplit, "test");
	Parse(params, ValidationSplit, "validation");
	Parse(params, PopulationSize, "popsize");
	Parse(params, MaxLoopCount, "loop");
	Parse(params, KFold, "folds");
	Parse(params, Alpha, "alpha");
	Parse(params, Kcover, "kcover");
	Parse(params, Kover, "kover");
	Parse(params, Ktok, "ktok");

	STRING jobName;
	Parse(params, jobName, "job");
	STRING job[] = { "learn", "block", "split", "collect", "align"};
	Job = -1;
	for (INT32 i = 0; i < 6; i++)
	if (jobName.compare(job[i]) == 0)
	{
		Job = i;
		break;
	}

	STRING learnAlgorithm;
	Parse(params, learnAlgorithm, "algorithm");
	STRING algo[] = { "naive", "heuristic", "exhaustive", "infogain", "genetic", "acceptall", "svm", "j48", "adaboost" };	
	for (INT32 i = 0; i < 9; i++)
	if (learnAlgorithm.compare(algo[i]) == 0)
	{
		LearnAlgorithm = i; 
		break;
	}

	Parse(params, StartupDirectory, "startup");
	INT32 idx = StartupDirectory.find_last_of("/\\");
	if (idx > 0)
		StartupDirectory.erase(idx, StartupDirectory.length() - idx);
	else
		StartupDirectory = STRING(".") + SLASH;	
	TempDirectory = StartupDirectory;
	Parse(params, TempDirectory, "temp"); //if temp is not available, use startup
}

Aggregator::Aggregator(INT32 mask)
{
	pFunc = Linear;
	K = mask >> 3;
	useBoolean = (mask >> 2) & 1;
	useAverage = (mask >> 1) & 1;
	useWeighting = mask & 1;
}
