#include "cLearn.h"

VOID GenerateAlignment(ASLParameter params, STRING strOutDir)
{
	DataSource dSrc(params.SourceRepositoryPath);
	DataSource dDes(params.TargetRepositoryPath);
	DataSource::LoadTokenID(params.SourceRepositoryPath, params.TargetRepositoryPath);
	VECTOR<Alignment> alg;
	VECTOR<VECTOR<INT32>> sharedTokens;
	INT64 t1 = TickCount();
	Align(&dSrc, &dDes, params, &alg, &sharedTokens);
	t1 = TickCount() - t1;
	LOGSTR(LOGSTREAM, "Alignment," << params.Jobname << "," << t1 << endl);
	Save(strOutDir + SLASH + params.Jobname + ".align", alg);

	DataSource::ClearTokenID();
}

VOID GenerateBlockingFile(ASLParameter params, STRING strOutDir)
{
	DataSource dSrc(params.SourceRepositoryPath);
	DataSource dDes(params.TargetRepositoryPath);
	DataSource::LoadTokenID(params.SourceRepositoryPath, params.TargetRepositoryPath);
	VECTOR<Alignment> alg;
	VECTOR<VECTOR<INT32>> sharedTokens;
	INT64 t1 = TickCount();
	Align(&dSrc, &dDes, params, &alg, &sharedTokens);
	t1 = TickCount() - t1;
	LOGALL("Alignment," << params.Jobname << "," << t1 << endl);
	Save(strOutDir + SLASH + params.Jobname + ".align", alg);
	INT64 t2 = TickCount();
	Block(&dSrc, &dDes, &alg, &sharedTokens, params, strOutDir + SLASH + params.Jobname + ".block");
	t2 = TickCount() - t2;
	LOGALL("Blocking," << params.Jobname << "," << t2 << endl);
	DataSource::ClearTokenID();
}

VOID GenerateSplit(ASLParameter params, INT32 nRepeat, STRING strOutDir)
{
	BlockSpliter bBlock(params.BlockFile);
	bBlock.BeginSplit(LoadReference(params.LabelFile), params.TrainingSplit, params.ValidationSplit, params.TestSplit, params.KFold);
	INT8 outBuf[1024];
	while (nRepeat--)
	{
		bBlock.Split();
		sprintf(outBuf, "%s_%02d_%.02f_%.02f_%.02f_%03d", params.Jobname.c_str(), params.KFold, params.TrainingSplit, params.ValidationSplit, params.TestSplit, nRepeat);
		bBlock.Save(strOutDir + SLASH + outBuf);
	}
}

